

varying vec4 color;
flat varying vec3 torch;
varying vec2 texcoord;
varying float skylight;

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)







const vec3 torchColor = vec3(3.000, 1.382, 0.408);

void main()
{
    texcoord.xy = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;
    color = gl_Color;

    torch = (pow(gl_MultiTexCoord1.x * recip, 6.0) * 0.5) * torchColor * 3.0;
    skylight = pow(gl_MultiTexCoord1.x * recip, 6.0);

    vec3 position = mat3(gl_ModelViewMatrix) * vec3(gl_Vertex) + gl_ModelViewMatrix[3].xyz;
    gl_Position = taaFunc(toClipSpace4(position));
}
